<?php

namespace App\Modules\TempApplication\Migrations\payCustomer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayCustomer extends Model 
{

    protected $table = 'tmp_pay_customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

    public function vendor()
    {
        return $this->belongsTo('TmpPayVendor', 'pay_vendor_id');
    }

}